/*ALIAS>l_data*/

/*SQLStart>1080*/
CREATE TABLE ROOMREG (
    RR_ID INTEGER NOT NULL,
    RR_DEALER INTEGER NOT NULL,
    RR_MANAGER INTEGER,
    RR_OBJECT INTEGER NOT NULL,
    RR_TYPE INTEGER NOT NULL,
    RR_NOTICE INTEGER,
    RR_CERTNUM VARCHAR(100),
    RR_CERTDATE DATE,
    RR_REGNUM VARCHAR(100),
	RR_REGDATE DATE,
	RR_STOPNUM VARCHAR(100),
	RR_STOPDATE DATE,
    RR_CAPACITY VARCHAR(100),
    RR_CAPACITY_INT INTEGER,
    RR_BEDS VARCHAR(100),
	RR_BEDS_INT INTEGER,
	RR_SEASON VARCHAR(100),
	RR_INPUTNUM VARCHAR(100),
	RR_INPUTDATE DATE,
    RR_COMMENT BLOB SUB_TYPE 1);
/*SQLStop*/

/*SQLStart>1081*/
ALTER TABLE ROOMREG ADD CONSTRAINT PK_ROOMREG PRIMARY KEY (RR_ID);
/*SQLStop*/

/*SQLStart>1082*/
CREATE GENERATOR GEN_ROOMREG_ID;
/*SQLStop*/

/*SQLStart>1083*/
create trigger ROOMREG_bi for ROOMREG
active before insert position 0
as
begin
  if (new.rr_id is null) then
    new.rr_id = gen_id(gen_ROOMREG_id,1);
end
/*SQLStop*/

/*SQLStart>1084*/
GRANT ALL ON ROOMREG TO PUBLIC
/*SQLStop*/

/*SQLStart>1085*/
CREATE TABLE ROOMREG_HIST (
    ID             INTEGER NOT NULL,
    HISTORY_DATE   DATE NOT NULL,
    HISTORY_TYPE   INTEGER NOT NULL,
    HISTORY_GROUP  INTEGER DEFAULT 0 NOT NULL,
    USER_ID        INTEGER NOT NULL,
    RR_ID INTEGER NOT NULL,
    RR_DEALER INTEGER NOT NULL,
    RR_MANAGER INTEGER NOT NULL,
    RR_OBJECT INTEGER NOT NULL,
    RR_TYPE INTEGER NOT NULL,
    RR_NOTICE INTEGER,
    RR_CERTNUM VARCHAR(100),
    RR_CERTDATE DATE,
    RR_REGNUM VARCHAR(100),
	RR_REGDATE DATE,
	RR_STOPNUM VARCHAR(100),
	RR_STOPDATE DATE,
    RR_CAPACITY VARCHAR(100),
    RR_CAPACITY_INT INTEGER,
    RR_BEDS VARCHAR(100),
	RR_BEDS_INT INTEGER,
	RR_SEASON VARCHAR(100),
	RR_INPUTNUM VARCHAR(100),
	RR_INPUTDATE DATE,
    RR_COMMENT BLOB SUB_TYPE 1);
/*SQLStop*/

/*SQLStart>1086*/
ALTER TABLE ROOMREG_HIST ADD CONSTRAINT PK_ROOMREG_HIST PRIMARY KEY (ID);
/*SQLStop*/

/*SQLStart>1087*/
CREATE INDEX ROOMREG_HIST_HG ON ROOMREG_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>1088*/
CREATE GENERATOR GEN_HIST_ROOMREG_ID
/*SQLStop*/

/*SQLStart>1089*/
CREATE OR ALTER TRIGGER ROOMREG_hist_bi for ROOMREG_hist
ACTIVE BEFORE INSERT OR UPDATE POSITION 0
as
begin
  if (new.ID is null) then 
    new.id = gen_id(GEN_HIST_ROOMREG_ID,1);
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end
/*SQLStop*/

/*SQLStart>1090*/
GRANT ALL ON ROOMREG_HIST TO PUBLIC
/*SQLStop*/

/*SQLStart>1091*/
CREATE TABLE ROOMREG_TYPE (
    RRT_ID INTEGER NOT NULL,
    RRT_TEXT VARCHAR(240) NOT NULL,
    RRT_NUMKIND INTEGER
)
/*SQLStop*/

/*SQLStart>1092*/
ALTER TABLE ROOMREG_TYPE ADD CONSTRAINT PK_ROOMREG_TYPE PRIMARY KEY (RRT_ID);
/*SQLStop*/

/*SQLStart>1093*/
CREATE GENERATOR GEN_ROOMREG_TYPE_ID;
/*SQLStop*/

/*SQLStart>1094*/
create trigger ROOMREG_type_bi for ROOMREG_type
active before insert position 0
as
begin
  if (new.rrt_id is null) then
    new.rrt_id = gen_id(gen_ROOMREG_type_id,1);
end
/*SQLStop*/

/*SQLStart>1095*/
GRANT ALL ON ROOMREG_TYPE TO PUBLIC
/*SQLStop*/

/*SQLStart>1096*/
CREATE TABLE ROOMREG_TYPE_HIST (
    ID             INTEGER NOT NULL,
    HISTORY_DATE   DATE NOT NULL,
    HISTORY_TYPE   INTEGER NOT NULL,
    HISTORY_GROUP  INTEGER DEFAULT 0 NOT NULL,
    USER_ID        INTEGER NOT NULL,
    RRT_ID INTEGER NOT NULL,
    RRT_TEXT VARCHAR(240) NOT NULL,
    RRT_NUMKIND INTEGER
)
/*SQLStop*/

/*SQLStart>1097*/
ALTER TABLE ROOMREG_TYPE_HIST ADD CONSTRAINT PK_ROOMREG_TYPE_HIST PRIMARY KEY (ID);
/*SQLStop*/

/*SQLStart>1098*/
CREATE GENERATOR GEN_HIST_ROOMREG_TYPE_ID;
/*SQLStop*/

/*SQLStart>1099*/
create trigger ROOMREG_TYPE_HIST_bi for ROOMREG_TYPE_HIST
active before insert position 0
as
begin
  if (new.ID is null) then 
    new.id = gen_id(GEN_HIST_ROOMREG_TYPE_ID,1);
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end
/*SQLStop*/

/*SQLStart>1100*/
CREATE INDEX ROOMREG_TYPE_HIST_HG ON ROOMREG_TYPE_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>1101*/
GRANT ALL ON ROOMREG_TYPE_HIST TO PUBLIC
/*SQLStop*/

/*ManyStart>1102*/
INSERT INTO ROOMREG_TYPE (RRT_TEXT) VALUES ('  ');
INSERT INTO ROOMREG_TYPE (RRT_TEXT) VALUES ('  ');
INSERT INTO ROOMREG_TYPE_HIST (HISTORY_TYPE, HISTORY_GROUP, USER_ID, RRT_ID, RRT_TEXT) VALUES (1, 0, 1, 1, '  ');
INSERT INTO ROOMREG_TYPE_HIST (HISTORY_TYPE, HISTORY_GROUP, USER_ID, RRT_ID, RRT_TEXT) VALUES (1, 0, 1, 2, '  ');
/*ManyStop*/

/*SQLStart>1103*/
ALTER TABLE ROOMREG
ADD CONSTRAINT FK_ROOMREG_DEALER
FOREIGN KEY (RR_DEALER)
REFERENCES FIRMS(F_ID)
ON DELETE SET NULL
ON UPDATE CASCADE
/*SQLStop*/

/*SQLStart>1104*/
ALTER TABLE ROOMREG
ADD CONSTRAINT FK_ROOMREG_MANAGER
FOREIGN KEY (RR_MANAGER)
REFERENCES FIRMS(F_ID)
ON DELETE SET NULL
ON UPDATE CASCADE
/*SQLStop*/

/*SQLStart>1105*/
ALTER TABLE ROOMREG
ADD CONSTRAINT FK_ROOMREG_OBJECT
FOREIGN KEY (RR_OBJECT)
REFERENCES OBJECTS(O_ID)
ON DELETE SET NULL
ON UPDATE CASCADE
/*SQLStop*/

/*SQLStart>1106*/
ALTER TABLE OBJECTS ADD O_CADNUM VARCHAR(100)
/*SQLStop*/

/*SQLStart>1107*/
ALTER TABLE OBJECTS_HIST ADD O_CADNUM VARCHAR(100)
/*SQLStop*/

/*SQLStart>1108*/
delete from system_strings where SYS_ID = 0;
/*SQLStop*/

/*SQLStart>1109*/
insert into system_strings (SYS_ID,SYS_STR) values (0,'1.5.60.1');
/*SQLStop*/

