/*ALIAS>prop_db*/

/*SQLStart>2010*/
ALTER TABLE DOCUMENTS ADD DOC_REQUEST VARCHAR(255);
/*SQLStop>*/

/*SQLStart>2012*/
ALTER TABLE DOCUMENTS ADD DOC_SHID INTEGER;
/*SQLStop>*/

/*SQLStart>2014*/
CREATE GENERATOR SH_ID_GEN;
/*SQLStop>*/

/*SQLStart>2016*/
CREATE TABLE SCHEME_KL (
    SH_ID    INTEGER NOT NULL,
    SH_TEXT  VARCHAR(255)
);
/*SQLStop>*/

/*SQLStart>2018*/
ALTER TABLE SCHEME_KL ADD CONSTRAINT PK_SCHEME_KL PRIMARY KEY (SH_ID);
/*SQLStop>*/

/*SQLStart>2020*/
CREATE OR ALTER TRIGGER SET_SH_ID FOR SCHEME_KL
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  if ((NEW.SH_ID is NULL) OR (NEW.SH_ID < 1)) then
  begin
    NEW.SH_ID = GEN_ID(SH_ID_GEN, 1);
  end
end;
/*SQLStop>*/

/*SQLStart>2022*/
GRANT ALL ON SCHEME_KL TO PUBLIC;
/*SQLStop>*/

/*SQLStart>2024*/
GRANT ALL ON SCHEME_KL TO SYSCREAT WITH GRANT OPTION;
/*SQLStop>*/

/*ManyStart>2026*/
update documents set doc_request = doc_addnum where doc_type = 1400;
update documents set doc_addnum = null where doc_type = 1400;
/*ManyStop*/

/*SQLStart>2028*/
create or alter  procedure UPDATES_HIST (
    SUNO integer,
    SUFN varchar(100),
    SUFD date,
    SUCN varchar(20),
    SUUN varchar(20))
returns (
    SUID integer)
as
BEGIN
  insert into SQL_updates(SU_No,SU_date,SU_fileName,SU_FileDate,
               SU_CompName,SU_UserName)
  values(:SUNo,"now",:SuFn,:SUFd,:SUCn,:SUUN);
  SUID = gen_id(SU_ID_Gen,0);
  suspend;
END;
/*SQLStop>*/

/*SQLStart>2030*/
CREATE GENERATOR GEN_COLUMNLENGTHS_ID;
/*SQLStop>*/

/*SQLStart>2032*/
CREATE TABLE COLUMNLENGTHS (
    CL_ID     INTEGER NOT NULL,
    CL_FIELD  VARCHAR(100),
    CL_WIDTH  INTEGER
);
/*SQLStop>*/

/*SQLStart>2034*/
ALTER TABLE COLUMNLENGTHS ADD CONSTRAINT PK_COLUMNLENGTHS PRIMARY KEY (CL_ID);
/*SQLStop>*/

/*SQLStart>2036*/
CREATE OR ALTER TRIGGER SET_CL_ID FOR COLUMNLENGTHS
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  if ((NEW.CL_ID is NULL) OR (NEW.CL_ID < 1)) then
  begin
    NEW.CL_ID = GEN_ID(gen_columnlengths_id, 1);
  end
end;
/*SQLStop>*/

/*SQLStart>2038*/
GRANT ALL ON COLUMNLENGTHS TO PUBLIC;
/*SQLStop>*/

/*SQLStart>2040*/
GRANT ALL ON COLUMNLENGTHS TO SYSCREAT WITH GRANT OPTION;
/*SQLStop>*/

/*SQLStart>2042*/
CREATE OR ALTER procedure ADDCOMPDESCR (
    CDESCR varchar(250))
returns (
    CDID integer)
as
declare variable W_CDID integer;
Begin
  select CD_ID from CompDescr
  where  AClearStr(:CDescr) = AClearSTR(CD_STR)
  into   :W_CDID ;

  if( W_CDID is  null) then
    begin
      select max(CD_ID) from CompDescr
      into :W_CDID;
      W_CDId = W_CDID+1;
      insert into CompDescr (CD_ID,CD_Str) Values(:W_CDID,:CDescr);
    end
  CDID = W_CDID;
  suspend;
end;
/*SQLStop>*/

/*SQLStart>2046*/
update system_strings set sys_str = 1 where sys_id = 1030;
/*SQLStop>*/

/*SQLStart>2048*/
Insert Into BLOBSETTINGS Values (0, 1010, 'sList=1743779554 SetName1743779554=
SetColCount1743779554=1
Col1743779554_0= ');
/*SQLStop>*/

/*SQLStart>2050*/
CREATE OR ALTER TRIGGER RENTTYPES_BI0 FOR RENTTYPES
ACTIVE BEFORE INSERT POSITION 0
AS
declare variable tempid integer;
begin
  if (new.rt_id is null or (new.rt_id = 0) ) then
  begin
    select max(rt_id) from renttypes into tempid;
    new.rt_id = tempid + 1;
  end
end
/*SQLStop>*/

/*ManyStart>2060*/
update system_strings set sys_str = '6.7.175.1' where sys_id = 1401;  /*BackOffice*/
/*ManyStop*/