/*ALIAS>l_data*/

/*SQLStart>654*/
create table objectowner (
	objectowner_id integer not null,
	objectowner_objectid integer not null,
	objectowner_ownerid integer not null)
/*SQLStop*/

/*SQLStart>655*/
alter table objectowner add primary key (objectowner_id);
/*SQLStop*/

/*SQLStart>656*/
CREATE INDEX objectowneridx
ON objectowner (objectowner_objectid)
/*SQLStop*/

/*SQLStart>657*/
grant all on objectowner to public;
/*SQLStop*/

/*MANYStart>658*/
create generator objectowner_id_gen;
set generator objectowner_id_gen to 0;
/*MANYStop*/

/*SQLStart>659*/
create procedure FillObjectOwners
as
declare variable oo_id integer;
declare variable oo_objid integer;
declare variable oo_ownerid integer;
begin
    for select o_id, o_ownerid from objects
        where ((o_id > 0) and (o_ownerid > 0))
        into :oo_objid, :oo_ownerid
    do 
	begin
		oo_id = gen_id(objectowner_id_gen,1);
		insert into objectowner (objectowner_id,objectowner_objectid,objectowner_ownerid) 
						 values (:oo_id,:oo_objid,:oo_ownerid);
	end
end;
/*SQLStop*/

/*SQLStart>660*/
execute procedure FillObjectOwners;
/*SQLStop*/

/*SQLStart>661*/
drop procedure FillObjectOwners
/*SQLStop*/

/*SQLStart>662*/
alter table objects
	drop o_ownerid;
/*SQLStop*/

/*SQLStart>663*/
CREATE PROCEDURE INSERTOBEJCTOWNER (
    oo_objid integer,
    oo_ownerid integer)
as
declare variable oo_id integer;
begin
    select objectowner_id from objectowner
        where (objectowner_objectid = :oo_objid) and
              (objectowner_ownerid = :oo_ownerid)
        into :oo_id;
        if (oo_id is null) then begin
            oo_id = gen_id(objectowner_id_gen,1);
            insert into objectowner (objectowner_id,objectowner_objectid,objectowner_ownerid)
                             values (:oo_id,:oo_objid,:oo_ownerid);
        end
end
/*SQLStop*/

/*SQLStart>664*/
grant execute on procedure INSERTOBEJCTOWNER to public
/*SQLStop*/

/*SQLStart>665*/
delete from system_strings where SYS_ID = 0;
/*SQLStop*/

/*SQLStart>666*/
insert into system_strings (SYS_ID,SYS_STR) values (0,'0007');
/*SQLStop*/
