/*ALIAS>prop_db*/

/*SQLStart>2758*/
ALTER TABLE USERS
    ADD USER_ACTIVE_KASA BOOLEAN,
    ADD USER_ACTIVE_RENTS BOOLEAN,
    ADD USER_ACTIVE_PROPERTIES BOOLEAN,
    ADD USER_ACTIVE_INCOMES BOOLEAN;
/*SQLStop*/

/*SQLStart>2759*/
CREATE OR ALTER procedure AEUM_USER_UPDATE (
    ID integer,
    APPNAME varchar(100),
    USERNAME varchar(300),
    TITLE varchar(300),
    FIRST_NAME varchar(300),
    MIDDLE_NAME varchar(300),
    LAST_NAME varchar(300),
    PID varchar(300),
    POSITION_TEXT varchar(300))
as
declare variable RES integer;
declare variable active_kasa smallint;
declare variable active_properties smallint;
declare variable active_rents smallint;
declare variable active_incomes smallint;
begin
  select u1.user_id, u1.user_active_kasa, u1.user_active_rents,
         u1.user_active_properties, u1.user_active_incomes from users u1
  where u1.user_id = :id
  into :res, :active_kasa, :active_rents, :active_properties, :active_incomes;

  if (:APPNAME = "APROP") then
    active_properties=1;
  if (:APPNAME = "ARENTS") then
    active_rents=1;
  if (:APPNAME = "AINCOMES") then
    active_incomes=1;
  if (:APPNAME = "AKASA") then
    active_kasa=1;
  
  if (:res is Null) then
    begin
	  active_properties=COALESCE(:active_properties, 0);
	  active_rents=COALESCE(:active_rents, 0);
	  active_incomes=COALESCE(:active_incomes, 0);
	  active_kasa=COALESCE(:active_kasa, 0);
      insert into users (user_id, user_str, user_name, user_active_kasa, user_active_rents, user_active_properties, user_active_incomes)
      values (:id,atrimex(COALESCE(:first_name, "") || " " || COALESCE(:middle_name, "") || " " || COALESCE(:last_name, "")), :username,  :active_kasa, :active_rents, :active_properties, :active_incomes);
    end
  else
    begin
      update users u2 set
        u2.user_str=atrimex(COALESCE(:first_name, "") || " " || COALESCE(:middle_name, "") || " " || COALESCE(:last_name, "")),
        u2.user_name=:username,
        u2.user_active_kasa=:active_kasa,
        u2.user_active_rents=:active_rents,
        u2.user_active_properties=:active_properties,
        u2.user_active_incomes=:active_incomes
      where u2.user_id = :id;
    end
end
/*SQLStop*/

/*SQLStart>2760*/
update users u1 set u1.user_active_kasa=u1.user_active,u1.user_active_rents=u1.user_active,u1.user_active_properties=u1.user_active,u1.user_active_incomes=u1.user_active;
/*SQLStop*/

/*SQLStart>2761*/
CREATE OR ALTER trigger users_biu0 for users
active before insert or update position 0
AS
begin
  if ((new.user_name is null) or (new.user_name = ''))  then
  begin
    new.user_name=new.user_str;
  end
end
/*SQLStop*/

/*SQLStart>2762*/
create or alter procedure AEUM_USER_DELETE (
    ID integer,
    APPNAME varchar(100))
as
begin
  if (:APPNAME = "APROP") then
    update users u1 set u1.user_active_properties=0 where u1.user_id=:id;
  if (:APPNAME = "ARENTS") then
    update users u1 set u1.user_active_rents=0 where u1.user_id=:id;
  if (:APPNAME = "AINCOMES") then
    update users u1 set u1.user_active_incomes=0 where u1.user_id=:id;
  if (:APPNAME = "AKASA") then
    update users u1 set u1.user_active_kasa=0 where u1.user_id=:id;
end
/*SQLStop*/

/*SQLStart>2763*/
create or alter procedure ADD_USER (
    U_ID smallint,
    U_RNM varchar(72))
as
declare variable RES smallint;
BEGIN
  select User_id from Users
  where User_id = :U_id
  into :res;
  
  if (:res is Null) then
    begin
      insert into Users (User_id, User_str,user_active_kasa,user_active_rents,user_active_incomes,user_active_properties)
      values (:U_Id,:U_RNM,1,1,1,1);
    end
  else
    begin
      update Users set  User_STR = :U_RNM,user_active_kasa=1,user_active_rents=1,user_active_incomes=1,user_active_properties=1
      where User_id = :U_ID ;
    end
END
/*SQLStop*/

/*SQLStart>2764*/
ALTER TABLE USERS DROP USER_ACTIVE;
/*SQLStop*/

/*SQLStart>2765*/
update system_strings set sys_str = '6.7.230.1' where sys_id = 1401; 
/*SQLStop*/
