/*ALIAS>prop_db*/

/*SQLStart>2626*/
ALTER TABLE USERS 
  ADD USER_NAME VARCHAR(120),
  ADD USER_ACTIVE BOOLEAN;
/*SQLStop*/

/*SQLStart>2627*/
update users set users.user_active = 1;
/*SQLStop*/

/*SQLStart>2628*/
update users set users.user_name = users.user_str;
/*SQLStop*/

/*SQLStart>2629*/
CREATE OR ALTER trigger users_biu0 for users
active before insert or update position 0
AS
begin
  if ((new.user_name is null) or (new.user_name = ''))  then
  begin
    new.user_name=new.user_str;
  end
  if (new.user_active is null) then
  begin
    new.user_active=1;
  end
end
/*SQLStop*/

/*SQLStart>2630*/
create or alter procedure AEUM_USER_UPDATE (
    ID integer,
    APPNAME varchar(100),
    USERNAME varchar(300),
    TITLE varchar(300),
    FIRST_NAME varchar(300),
    MIDDLE_NAME varchar(300),
    LAST_NAME varchar(300),
    PID varchar(300),
    POSITION_TEXT varchar(300))
as
declare variable RES integer;
begin
  select u1.user_id from users u1
  where u1.user_id = :id
  into :res;
  
  if (:res is Null) then
    begin
      insert into users (user_id, user_str, user_name)
      values (:id,atrimex(:first_name || " " || :middle_name || " " || :last_name), :username);
    end
  else
    begin
      update users u2 set
        u2.user_str=atrimex(:first_name || " " || :middle_name || " " || :last_name),
        u2.user_name=:username
      where u2.user_id = :id;
    end
end
/*SQLStop*/

/*SQLStart>2631*/
GRANT EXECUTE ON PROCEDURE AEUM_USER_UPDATE TO PUBLIC;
/*SQLStop*/

/*SQLStart>2632*/
create or alter procedure AEUM_USER_DELETE (
    ID integer,
    APPNAME varchar(100))
as
begin
  update users u1 set u1.user_active=0 where u1.user_id=:id;
end
/*SQLStop*/

/*SQLStart>2633*/
GRANT EXECUTE ON PROCEDURE AEUM_USER_DELETE TO PUBLIC;
/*SQLStop*/

/*SQLStart>2634*/
update system_strings set sys_str = '6.7.214.1' where sys_id = 1401;
/*SQLStop*/
