/*ALIAS>prop_db*/

/*SQLStart>2610*/
ALTER TABLE DOCUMENTS DROP CONSTRAINT INTEG_20;
/*SQLStop*/

/*SQLStart>2611*/
ALTER TABLE DOCUMENTS ADD CONSTRAINT PK_DOCUMENTS PRIMARY KEY (DOC_ID);
/*SQLStop*/

/*SQLStart>2612*/
ALTER TABLE DOCUMENTS ADD CONSTRAINT UNQ_DOCUMENTS UNIQUE (DOC_ID,DOC_NUM);
/*SQLStop*/

/*SQLStart>2613*/
CREATE TABLE PROPDOCS (
    DOCUMENTID INTEGER NOT NULL,
    PROPERTYID INTEGER NOT NULL);
/*SQLStop*/

/*SQLStart>2614*/
ALTER TABLE PROPDOCS ADD CONSTRAINT PK_PROPDOCS PRIMARY KEY (PROPERTYID,DOCUMENTID);
/*SQLStop*/

/*SQLStart>2615*/
GRANT ALL ON PROPDOCS TO PUBLIC;
/*SQLStop*/

/*SQLStart>2616*/
create or alter procedure FILLPROPDOCS
as
declare variable DOCID integer;
declare variable PROPID integer;
begin
    for select d1.doc_id, d1.doc_imotid from documents d1
    inner join imot i1 on d1.doc_imotid = i1.im_id
    into :docid, :propid
    do
    begin
        insert into propdocs (DOCUMENTID, PROPERTYID) values (:docid, :propid);
    end

    suspend;
end;
/*SQLStop*/

/*SQLStart>2617*/
GRANT EXECUTE ON PROCEDURE FILLPROPDOCS TO PUBLIC;
/*SQLStop*/

/*SQLStart>2618*/
EXECUTE PROCEDURE FILLPROPDOCS;
/*SQLStop*/

/*SQLStart>2619*/
DROP PROCEDURE FillPropDocs;
/*SQLStop*/

/*SQLStart>2620*/
DROP INDEX DOCIMOTIDX;
/*SQLStop*/

/*SQLStart>2621*/
ALTER TABLE DOCUMENTS DROP DOC_IMOTID;
/*SQLStop*/

/*SQLStart>2622*/
ALTER TABLE PROPDOCS ADD CONSTRAINT FK_PD2DOCS FOREIGN KEY (DOCUMENTID) REFERENCES DOCUMENTS(DOC_ID) ON DELETE CASCADE ON UPDATE CASCADE;
/*SQLStop*/

/*SQLStart>2623*/
ALTER TABLE PROPDOCS ADD CONSTRAINT FK_PD2PROP FOREIGN KEY (PROPERTYID) REFERENCES IMOT(IM_ID) ON DELETE CASCADE ON UPDATE CASCADE;
/*SQLStop*/

/*SQLStart>2624*/
ALTER TABLE renttypes ADD RT_REGISTRYFLAG INTEGER;
/*SQLStop*/

/*SQLStart>2625*/
update system_strings set sys_str = '6.7.213.1' where sys_id = 1401;
/*SQLStop*/
