/*ALIAS>prop_db*/

/*SQLStart>2470*/
	CREATE GENERATOR GEN_BONUSTYPE_ID;
/*SQLStop*/

/*SQLStart>2472*/
	CREATE TABLE BONUSTYPE (
		BT_ID      INTEGER NOT NULL,
		BT_NAME    VARCHAR(255) NOT NULL,
		BT_DESCR   BLOB SUB_TYPE 1 SEGMENT SIZE 80,
		BT_PERCENT NUMERIC(15,3) NOT NULL,
		BT_PAYONCE INTEGER DEFAULT 0 NOT NULL,
		BT_MONTHS INTEGER NOT NULL
	);
/*SQLStop*/

/*SQLStart>2474*/
	ALTER TABLE BONUSTYPE ADD CONSTRAINT PK_BONUSTYPE PRIMARY KEY (BT_ID);
/*SQLStop*/

/*SQLStart>2476*/
	CREATE OR ALTER TRIGGER BONUSTYPE_BI FOR BONUSTYPE
	ACTIVE BEFORE INSERT POSITION 0
	as
	begin
	  if ((new.bt_id is null) or (new.bt_id = 0)) then
		new.bt_id = gen_id(gen_bonustype_id,1);
	end
/*SQLStop*/

/*SQLStart>2478*/
	GRANT ALL ON BONUSTYPE TO PUBLIC;
/*SQLStop*/

/*SQLStart>2480*/
	CREATE TABLE RENTBONUS (
		RB_RENTTYPE_ID INTEGER NOT NULL,
		RB_BONUSTYPE_ID INTEGER NOT NULL)
/*SQLStop*/

/*ManyStart>2482*/
	ALTER TABLE RENTBONUS
	ADD CONSTRAINT PK_RENTBONUS
	PRIMARY KEY (RB_RENTTYPE_ID,RB_BONUSTYPE_ID);
	
	ALTER TABLE RENTBONUS
	ADD CONSTRAINT FK_RENTBONUS_RENT
	FOREIGN KEY (RB_RENTTYPE_ID)
	REFERENCES RENTTYPES(RT_ID)
	ON DELETE CASCADE
	ON UPDATE CASCADE;
	
	ALTER TABLE RENTBONUS
	ADD CONSTRAINT FK_RENTBONUS_BONUS
	FOREIGN KEY (RB_BONUSTYPE_ID)
	REFERENCES BONUSTYPE(BT_ID)
	ON DELETE CASCADE
	ON UPDATE CASCADE
/*ManyStop*/

/*SQLStart>2484*/
	GRANT ALL ON RENTBONUS TO PUBLIC;
/*SQLStop*/

/*SQLStart>2486*/
	ALTER TABLE PAYMENT
	ADD P_BONUS NUMERIC(15,2);
/*SQLStop*/

/*SQLStart>2488*/
	ALTER TABLE WAITPAYMENTS
	ADD WP_BONUS NUMERIC(15,2)
/*SQLStop*/

/*SQLStart>2490*/
	update system_strings set sys_str = '6.7.194.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/