/*ALIAS>prop_db*/

/*SQLStart>2160*/
CREATE OR ALTER procedure ADDCOMPDESCR (
    CDESCR varchar(250))
returns (
    CDID integer)
as
declare variable W_CDID integer;
begin
  select CD_ID from compdescr
  where  (AClearStr(:CDescr)=aclearstr(CD_STR))
  into   :w_cdid ;

  if( w_cdid is not null) then
    begin
      suspend;
      exit;
    end


  select max(CD_ID) from compdescr
  into :w_cdid;

  if( w_cdid is not null) then
    begin
      w_cdid=w_cdid+1;
    end
  else
    begin
      w_cdid = 1;
    end

  insert into compdescr (CD_ID,CD_Str) Values(:w_cdid,:cdescr);
  cdid = w_cdid;
  suspend;
end
/*SQLStop*/

/*SQLStart>2161*/
CREATE TABLE MAILMESSAGES (
    MM_ID        INTEGER NOT NULL,
    MM_MASSAGE   BLOB SUB_TYPE 0 SEGMENT SIZE 4096,
    MM_SUBJECT   VARCHAR(255),
    MM_SENDER    VARCHAR(255),
    MM_RECIVERS  VARCHAR(255),
    MM_ISSENT    INTEGER,
    MM_USERID    INTEGER NOT NULL
);
/*SQLStop*/

/*SQLStart>2162*/
ALTER TABLE MAILMESSAGES ADD CONSTRAINT PK_MAILMESSAGES PRIMARY KEY (MM_ID);
/*SQLStop*/

/*SQLStart>2163*/
CREATE GENERATOR MAILMESSAGES_GEN;
/*SQLStop>*/

/*SQLStart>2164*/
CREATE OR ALTER TRIGGER SET_MAIL_ID FOR MAILMESSAGES
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  if((new.mm_id is null) or (new.mm_id=0))then
  begin
    NEW.mm_id=GEN_ID(mailmessages_gen,1);
  end
END
/*SQLStop*/

/*SQLStart>2165*/
GRANT ALL ON MAILMESSAGES TO PUBLIC;
/*SQLStop*/

/*SQLStart>2166*/
GRANT ALL ON MAILMESSAGES TO SYSCREAT WITH GRANT OPTION;
/*SQLStop*/

/*SQLStart>2167*/
DROP TABLE KO_KL;
/*SQLStop*/

/*SQLStart>2168*/
DROP TABLE NE_KL;
/*SQLStop*/

/*SQLStart>2169*/
DROP TABLE NTP_KL;
/*SQLStop*/

/*SQLStart>2170*/
DROP TABLE PR_KL;
/*SQLStop*/

/*SQLStart>2171*/
DROP TABLE ST_KL;
/*SQLStop*/

/*SQLStart>2172*/
update system_strings set sys_str = '6.7.180.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/
