/*ALIAS>prop_db*/

/*SQLStart>1578*/
ALTER TABLE IMOT_DESC
ADD ID_TEXT2 BLOB SUB_TYPE 1 SEGMENT SIZE 4096 CHARACTER SET WIN1251 
/*SQLStop>1578*/

/*SQLStart>1579*/
update imot_desc set id_text2 = id_text
/*SQLStop>1579*/

/*SQLStart>1580*/
ALTER TABLE IMOT_DESC DROP ID_TEXT
/*SQLStop>1580*/

/*SQLStart>1581*/
ALTER TABLE IMOT_DESC ALTER ID_TEXT2 TO ID_TEXT
/*SQLStop>1581*/

/****************************************************/

/*ManyStart>1582*/
CREATE TABLE DOC_NOTE (
    DN_ID INTEGER NOT NULL,
    DN_DOCID INTEGER,
    DN_DATE DATE,
    DN_TEXT BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    DN_ADDREMARK CHAR(600) CHARACTER SET WIN1251 COLLATE WIN1251 );

alter table DOC_NOTE
add constraint PK_DOC_NOTE
primary key (DN_ID);

CREATE GENERATOR DN_ID_GEN; 
/*ManyStop>1582*/

/*SQLStart>1583*/
CREATE TRIGGER DOC_NOTE_BIO FOR DOC_NOTE
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  new.DN_ID=gen_id(DN_ID_GEN,1);
end
/*SQLStop>1583*/

/*SQLStart>1584*/
grant all on DOC_NOTE to public
/*SQLStop>1584*/


/*SQLStart>1585*/
alter table imot alter im_addressnom type varchar(40)
/*SQLStop>1585*/

/*SQLStart>1586*/
update RDB$FIELDS set
RDB$FIELD_LENGTH = 150,
RDB$CHARACTER_LENGTH = 150
where RDB$FIELD_NAME = 'ADM_VC50'
/*SQLStop>1586*/


/*SQLStart>1587*/
CREATE procedure FILLDOCNOTES
as
declare variable DOCID integer;
declare variable DOCDATE date;
declare variable DOCREMARKS blob sub_type 0 segment size 80;
begin
  for select doc_data, doc_remarks, doc_id from documents where doc_type in (8, 10, 12) and not (doc_remarks is null)
      into :docdate, :docremarks, :docid do
      begin
        if ( (:docremarks is not null) ) then
          insert into doc_note(dn_date, dn_docid, dn_text) values(:docdate, :docid, :docremarks);
      end
end
/*SQLStop>1587*/

/*SQLStart>1588*/
execute procedure filldocnotes;
/*SQLStop>1588*/


/*SQLStart>1589*/
ALTER TABLE DOCUMENTS ADD DOC_com2 BLOB SUB_TYPE 1 SEGMENT SIZE 4096 CHARACTER SET WIN1251; 
/*SQLStop>1589*/

/*MANYStart>1590*/
update documents set doc_com2 = doc_coment;
alter table documents drop doc_coment;
alter table documents alter doc_com2 to doc_coment;
/*MANYStop>1590*/

/*SQLStart>1591*/
alter table documents alter doc_imotplace type varchar(400)
/*SQLStop>1591*/

/*SQLStart>1592*/
alter table documents alter doc_kmet type varchar(90)
/*SQLStop>1592*/

/*SQLStart>1595*/
ALTER TABLE DOCUMENTS ADD DOC_owner2 BLOB SUB_TYPE 1 SEGMENT SIZE 4096 CHARACTER SET WIN1251; 
/*SQLStop>1595*/

/*MANYStart>1596*/
update documents set doc_owner2 = doc_owner;
alter table documents drop doc_owner;
alter table documents alter doc_owner2 to doc_owner;
/*MANYStop>1596*/

/*SQLStart>1597*/
ALTER TABLE DOCUMENTS ADD DOC_com3 BLOB SUB_TYPE 1 SEGMENT SIZE 4096 CHARACTER SET WIN1251; 
/*SQLStop>1597*/

/*MANYStart>1598*/
update documents set doc_com3 = doc_coment2;
alter table documents drop doc_coment2;
alter table documents alter doc_com3 to doc_coment2;
/*MANYStop>1598*/

/*SQLStart>1599*/
alter table documents alter doc_delo type varchar(400)
/*SQLStop>1599*/

/*SQLStart>1600*/
ALTER TABLE DOCUMENTS ADD DOC_prava BLOB SUB_TYPE 1 SEGMENT SIZE 4096 CHARACTER SET WIN1251; 
/*SQLStop>1600*/

/*MANYStart>1601*/
update documents set doc_prava = da_sf1;
alter table documents drop da_sf1;
alter table documents alter doc_prava to da_sf1;
/*MANYStop>1601*/

/*SQLStart>1602*/
alter table documents alter doc_nomtxt type varchar(30)
/*SQLStop>1602*/

/*SQLStart>1603*/
ALTER TABLE DOCUMENTS ADD DOC_ex2 BLOB SUB_TYPE 1 SEGMENT SIZE 4096 CHARACTER SET WIN1251; 
/*SQLStop>1603*/

/*MANYStart>1604*/
update documents set doc_ex2 = doc_exowner;
alter table documents drop doc_exowner;
alter table documents alter doc_ex2 to doc_exowner;
/*MANYStop>1604*/