/*ALIAS>prop_db*/

/*SQLStart>1496*/
ALTER TRIGGER TAXORDERS_BI
AS
begin
  NEW.TO_OrderDate = "NOW";
  NEW.TO_PayOpID = 0;
  NEW.TO_Paid = "F";
  NEW.TO_Anul = "F";
end
/*SQLStop>1496*/

/*SQLStart>1497*/
ALTER TRIGGER INVOICES_BI
as
begin
  NEW.IN_ClearPayDate = AStripTime(NEW.IN_PAYDATE);
end
/*SQLStop>1497*/

/*SQLStart>1498*/
ALTER PROCEDURE INVOICEADDHEADER(
    IN_PERID INTEGER,
    IN_PAYID INTEGER,
    IN_PAYTYPE CHAR(1),
    IN_PAYSUM NUMERIC(15,2),
    IN_PAYCLEARSUM NUMERIC(15,2),
    IN_PAYDDS NUMERIC(15,2),
    IN_PAYLIHVI NUMERIC(15,2),
    IN_PAYWAY CHAR(1),
    IN_COMMENT VARCHAR(250),
    IN_PAYTEXT VARCHAR(250),
    IN_OPERATORID INTEGER,
    IN_OBMOL VARCHAR(50),
    IN_PERPAYFROM VARCHAR(50),
    IN_PAYNODDSSUM NUMERIC(15,2),
    IN_PAYDDSSUM NUMERIC(15,2),
    IN_FACTOR NUMERIC(15,2),
    IN_PAYDATE DATE,
    IN_REALPAYDATE DATE,
    IN_NODDSDESCR VARCHAR(255),
    IN_DDSEVENTDATE DATE)
RETURNS (
    IN_ID INTEGER)
AS
DECLARE VARIABLE IN_OPERATORNAME VARCHAR(75);
DECLARE VARIABLE IN_PERNAME VARCHAR(75);
DECLARE VARIABLE IN_PERADDR VARCHAR(200);
DECLARE VARIABLE IN_PERNM VARCHAR(30);
DECLARE VARIABLE IN_PEREGN VARCHAR(15);
DECLARE VARIABLE IN_PERDANN VARCHAR(10);
DECLARE VARIABLE IN_PERMOLNAME VARCHAR(75);
DECLARE VARIABLE IN_PERINDDS VARCHAR(15);
DECLARE VARIABLE IN_PER_ADDR_CORESP varchar(250);
DECLARE VARIABLE IN_PER_TDNAP varchar(20);
DECLARE VARIABLE IN_PER_TDNAP_ADDR varchar(50);
begin
  /* wzima se imeto na kasiera */
  select USER_STR from users
  where USER_ID = :IN_OperatorID
  into :IN_OperatorName;

  /* wzimat se dannite na personata */
  select PerName, PerEgn, PerDanN, PerAddr, PerNM, PerMolName, PerINDDS, PerAddr_Coresp, PerTDNap, PerTDNap_Addr
  from PersonGetInfo(:IN_PerID)
  into :IN_PerName, :IN_PerEgn, :IN_PerDanN, :IN_PerAddr, :IN_PerNM, :IN_PERMOLNAME, :IN_PERINDDS,
  :IN_PER_ADDR_CORESP, :IN_PER_TDNAP, :IN_PER_TDNAP_ADDR;

  if (IN_PAYDATE < "01.01.1990" ) then
    IN_PayDate = "NOW";

  if (IN_DDSEVENTDATE < "01.01.1990" ) then
    IN_DDSEVENTDATE = IN_PayDate;
  
  IN_ID = GEN_ID(IN_ID_GEN, 1);
  insert into Invoices (IN_ID, IN_PERID, IN_PERNAME, IN_PERADDR, IN_PERNM, IN_PEREGN,
                        IN_PERDANN, IN_PERMOLNAME, IN_PAYTYPE, IN_PAYTEXT, IN_PAYID,
                        IN_PAYSUM, IN_PAYDDS, IN_OPERATORID, IN_OPERATORNAME, IN_PAYLIHVI,
                        IN_PAYWAY, IN_ANUL, IN_COMMENT, IN_PAYCLEARSUM,
                        IN_OBMOL, IN_REAL, IN_PerPayFrom,
                        IN_PayDDSSum, IN_PayNoDDSSum, IN_FACTOR, IN_PAYDATE, IN_REALPAYDATE, 
                        IN_PERINDDS, IN_FLAG2007, IN_NODDSDESCR, IN_DDSEVENTDATE,
                        IN_PER_ADDR_CORESP, IN_PER_TDNAP, IN_PER_TDNAP_ADDR)
  values               (:IN_ID, :IN_PERID, :IN_PERNAME, :IN_PERADDR, :IN_PERNM, :IN_PEREGN,
                        :IN_PERDANN, :IN_PERMOLNAME, :IN_PAYTYPE, :IN_PAYTEXT, :IN_PAYID,
                        :IN_PAYSUM, :IN_PAYDDS, :IN_OPERATORID, :IN_OPERATORNAME, :IN_PAYLIHVI,
                        :IN_PAYWAY, "A", :IN_COMMENT, :IN_PAYCLEARSUM,
                        :IN_OBMOL, "F", :IN_PerPayFrom,
                        :IN_PayDDSSum, :IN_PayNoDDSSum, :IN_FACTOR, :IN_PAYDATE, :IN_REALPAYDATE,
                        :IN_PERINDDS, "T", :IN_NODDSDESCR, :IN_DDSEVENTDATE,
                        :IN_PER_ADDR_CORESP, :IN_PER_TDNAP, :IN_PER_TDNAP_ADDR);
  
  suspend;
end
/*SQLStop>1498*/

/*SQLStart>1499*/
ALTER PROCEDURE TAXORDERADD(
    TOTAXID SMALLINT,
    TOPERID INTEGER,
    TOPRICE NUMERIC(15,2),
    TOOPERATORID SMALLINT,
    TOVALIDDATE DATE,
    TOMUSTPAYDATE DATE,
    TOTEXT VARCHAR(250),
    TOGROUP INTEGER,
    TODOCID INTEGER)
RETURNS (
    TO_ID INTEGER)
AS
declare variable ino integer; 
Begin
  ino = 0;
  to_id = GEN_ID(TO_ID_GEN, 1);
  insert into TaxOrders (TO_ID, TO_TaxID, TO_PerID, TO_Price, TO_OrderOpId, TO_ValidDate, TO_MustPayDate, TO_No, TO_TEXT, TO_GROUP, TO_DOCID)
                 values (:TO_ID, :TOTaxID, :TOPerID, :TOPrice, :TOOperatorID,  :TOValidDate, :TOMustPayDate, :ino, :TOTEXT, :TOGROUP, :TODOCID);
  Suspend;
end
/*SQLStop>1499*/
